<?php
/*--------------------------------------------------------------------------------------------------
    AbstractGroup.php 2020-01-23
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\ProductModifiers\Groups;

use Gambio\Shop\ProductModifiers\Groups\ValueObjects\GroupIdentifierInterface;
use Gambio\Shop\ProductModifiers\Groups\ValueObjects\GroupName;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifiersCollection;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifiersCollectionInterface;
use Gambio\Shop\ProductModifiers\Presentation\Core\PresentationTypeInterface;

/**
 * Class AbstractGroup
 * @package Gambio\Shop\ProductModifiers\Groups
 */
abstract class AbstractGroup implements GroupInterface
{
    /**
     * @var GroupIdentifierInterface
     */
    protected $id;
    /**
     * @var ModifiersCollectionInterface
     */
    protected $modifiers;
    /**
     * @var GroupName
     */
    protected $name;
    /**
     * @var PresentationTypeInterface
     */
    protected $type;
    
    
    /**
     * AbstractGroup constructor.
     *
     * @param GroupIdentifierInterface     $id
     * @param PresentationTypeInterface    $type
     * @param GroupName                    $name
     * @param ModifiersCollectionInterface $modifiers
     */
    public function __construct(
        GroupIdentifierInterface $id,
        PresentationTypeInterface $type,
        GroupName $name,
        ModifiersCollectionInterface $modifiers
    ) {
        $this->id        = $id;
        $this->name      = $name;
        $this->type      = $type;
        $this->modifiers = $modifiers;
    }
    
    
    /**
     * @inheritDoc
     */
    public function id(): GroupIdentifierInterface
    {
        return $this->id;
    }
    
    
    /**
     * @inheritDoc
     */
    public function modifiers(): ModifiersCollectionInterface
    {
        return new ModifiersCollection($this->modifiers);
    }
    
    
    /**
     * @inheritDoc
     */
    public function name(): GroupName
    {
        return $this->name;
    }
    
    
    /**
     * @inheritDoc
     */
    public function type(): PresentationTypeInterface
    {
        return $this->type;
    }
    
    
    /**
     * @inheritDoc
     */
    abstract public function selectFirstAsDefault(): bool;
    
    
}